"""empty message

Revision ID: 6a96dfdd7b41
Revises: 7cf46def1e6c
Create Date: 2017-04-28 07:27:33.511218

"""

# revision identifiers, used by Alembic.
revision = '6a96dfdd7b41'
down_revision = '7cf46def1e6c'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tb_log_view_filter',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('type_', sa.Integer(), nullable=True),
    sa.Column('display_name', sa.String(), nullable=False),
    sa.Column('filter_id', sa.String(), nullable=False),
    sa.Column('is_user_defined', sa.Boolean(), nullable=True),
    sa.Column('settings', postgresql.JSON(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_log_view_filter')),
    sa.UniqueConstraint('filter_id', name=op.f('uq_tb_log_view_filter_filter_id'))
    )
    op.create_table('tb_log_view_filter_instance',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('filter_id', sa.String(), nullable=False),
    sa.Column('owner', sa.String(), nullable=False),
    sa.Column('settings', postgresql.JSON(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_log_view_filter_instance')),
    sa.UniqueConstraint('filter_id', name=op.f('uq_tb_log_view_filter_instance_filter_id'))
    )
    op.create_table('tb_widget_category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('display_name', sa.String(), nullable=True),
    sa.Column('is_user_defined', sa.Boolean(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_widget_category')),
    sa.UniqueConstraint('display_name', name=op.f('uq_tb_widget_category_display_name'))
    )
    op.create_table('tb_widget_instance',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('instance_id', sa.String(), nullable=False),
    sa.Column('group_id', sa.String(36), nullable=False),
    sa.Column('display_name', sa.String(), nullable=False),
    sa.Column('widget_template_id', sa.String(length=100), nullable=False),
    sa.Column('settings', postgresql.JSON(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_widget_instance')),
    sa.UniqueConstraint('instance_id', name=op.f('uq_tb_widget_instance_instance_id'))
    )
    op.create_table('tb_widget_template',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('template_id', sa.String(length=100), nullable=False),
    sa.Column('display_name', sa.String(), nullable=False),
    sa.Column('filter_id', sa.String(), nullable=True),
    sa.Column('settings', postgresql.JSON(), nullable=True),
    sa.Column('predefined_settings', postgresql.JSON(), nullable=True),
    sa.Column('is_readonly', sa.Boolean(), nullable=True),
    sa.Column('category_ids', postgresql.ARRAY(sa.Integer()), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_widget_template')),
    sa.UniqueConstraint('template_id', name=op.f('uq_tb_widget_template_template_id')),
    sa.UniqueConstraint('display_name', 'is_readonly', name=op.f('uq_tb_widget_template_display_name_is_readonly'))
    )
    op.drop_constraint(u'fk_tb_acl_entry_role_id_tb_roles', 'tb_acl_entry', type_='foreignkey')
    op.drop_constraint(u'fk_tb_user_role_user_id_tb_users', 'tb_user_role', type_='foreignkey')

    op.create_table('tb_acl_owner',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('owner_name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=512), nullable=True),
    sa.Column('owner_type', sa.Integer(), nullable=False),
    sa.Column('modified_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_acl_owner')),
    sa.UniqueConstraint('owner_name', 'owner_type', name=op.f('uq_tb_acl_owner_owner_name'))
    )
    op.create_table('tb_usergroup_role',
    sa.Column('usergroup_id', sa.BigInteger(), nullable=False),
    sa.Column('role_id', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('usergroup_id', 'role_id', name=op.f('pk_tb_usergroup_role'))
    )
    op.create_table('tb_user_usergroup',
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('usergroup_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['tb_users.id'], name=op.f('fk_tb_user_usergroup_user_id_tb_users')),
    sa.ForeignKeyConstraint(['usergroup_id'], ['tb_acl_owner.id'], name=op.f('fk_tb_user_usergroup_usergroup_id_tb_acl_owner'), onupdate='CASCADE', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('user_id', 'usergroup_id', name=op.f('pk_tb_user_usergroup'))
    )
    op.add_column('tb_mail_outbox', sa.Column('attachments', postgresql.JSON(), nullable=True))
    op.add_column('tb_mail_outbox', sa.Column('extra_setting', postgresql.JSON(), nullable=True))
    op.create_table('tb_rpc_task',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.Column('package_type', sa.Integer(), nullable=False),
    sa.Column('package_hash', sa.String(), nullable=False),
    sa.Column('package_info', postgresql.JSON(), nullable=True),
    sa.Column('log_info', postgresql.JSON(), nullable=True),
    sa.Column('status', sa.Integer(), nullable=False, default=1),
    sa.Column('creator', sa.BigInteger(), nullable=True),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('last_modified_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_rpc_task'))
    )
    op.create_table('tb_local_cache',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.Column('package_type', sa.Integer(), nullable=False),
    sa.Column('package_hash', sa.String(), nullable=False),
    sa.Column('path', sa.String(), nullable=False),
    sa.Column('sha1', sa.String(length=40), nullable=False),
    sa.Column('sha256', sa.String(length=64), nullable=False),
    sa.Column('size', sa.BigInteger(), nullable=False),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_local_cache')),
    sa.UniqueConstraint('device_guid', 'package_type', 'package_hash', name=op.f('uq_tb_local_cache_device_guid_package_type_package_hash'))
    )
    op.create_table('tb_ignore_rule',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('comment', sa.String(length=512), nullable=True),
    sa.Column('query_string', postgresql.JSON(), nullable=False),
    sa.Column('last_update_by', sa.String(length=100), nullable=False),
    sa.Column('last_update_time', sa.DateTime(), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_ignore_rule')),
    sa.UniqueConstraint('name', name=op.f('uq_tb_ignore_rule_name'))
    )
    op.create_table('tb_mail_alert_custom_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('alert_id', sa.Integer(), nullable=False),
    sa.Column('display_name', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('creator_display_name', sa.String(), nullable=True),
    sa.Column('enabled', sa.Integer(), nullable=False),
    sa.Column('alert_level', sa.Integer(), nullable=False),
    sa.Column('alert_type', sa.Integer(), nullable=False),
    sa.Column('frequency', postgresql.JSON(), nullable=True),
    sa.Column('check_frequency', postgresql.JSON(), nullable=False),
    sa.Column('send_to_all', sa.Integer(), nullable=False),
    sa.Column('extra_setting', postgresql.JSON(), nullable=False),
    sa.Column('recipients', postgresql.JSON(), nullable=True),
    sa.Column('subject', sa.String(), nullable=False),
    sa.Column('message', sa.String(), nullable=False),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_mail_alert_custom_rule')),
    sa.UniqueConstraint('alert_id', name=op.f('uq_tb_mail_alert_custom_rule_alert_id')),
    sa.UniqueConstraint('display_name', name=op.f('uq_tb_mail_alert_custom_rule_display_name'))
    )
    op.execute('CREATE SEQUENCE tb_mail_alert_custom_rule_alert_id_seq')
    op.execute("ALTER TABLE tb_mail_alert_custom_rule ALTER COLUMN alert_id set default nextval('tb_mail_alert_custom_rule_alert_id_seq')")
    op.execute("SELECT setval('tb_mail_alert_custom_rule_alert_id_seq', 1000)")
    op.add_column('tb_mail_alert_rule', sa.Column('check_frequency', postgresql.JSON(), nullable=True))
    op.create_table('tb_syslog_forward_server',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.String(length=64), nullable=False, unique=True),
    sa.Column('ip', sa.String(), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('protocol', sa.Integer(), nullable=False, default=0),
    sa.Column('format', sa.Integer(), nullable=False, default=0),
    sa.Column('is_enabled', sa.Integer(), nullable=False, default=1),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_syslog_forward_server'))
    )
    op.create_table('tb_syslog_forward_task',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('type', sa.Integer(), nullable=False),
    sa.Column('facility', sa.Integer(), nullable=False, default=19),
    sa.Column('severity', sa.Integer(), nullable=False, default=4),
    sa.Column('server_id', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_syslog_forward_task')),
    sa.ForeignKeyConstraint(['server_id'], ['tb_syslog_forward_server.id'], name=op.f('fk_tb_syslog_forward_task_server_id_tb_syslog_forward_server_id'))
    )
    op.create_table('tb_journal_checkpoint',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('section_name', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('value', sa.String(), nullable=False),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_journal_checkpoint')),
    sa.UniqueConstraint('section_name', 'key', name='uq_tb_journal_checkpoint_section_name_key')
    )
    op.add_column(u'tb_mail_outbox', sa.Column('alert_guid', sa.String(length=36), nullable=True))
    op.add_column(u'tb_mail_outbox', sa.Column('display_name', sa.String(), nullable=True))
    op.add_column(u'tb_mail_outbox', sa.Column('alert_type', sa.Integer(), nullable=True))
    op.create_index(op.f('ix_tb_mail_outbox_alert_guid'), 'tb_mail_outbox', ['alert_guid'], unique=False)
    op.create_index(op.f('ix_tb_mail_outbox_display_name'), 'tb_mail_outbox', ['display_name'], unique=False)
    op.create_index(op.f('ix_tb_mail_outbox_alert_type'), 'tb_mail_outbox', ['alert_type'], unique=False)

    op.create_table('tb_disk_usage_stat',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('partition', sa.String(), nullable=False),
    sa.Column('total', sa.BigInteger(), nullable=False),
    sa.Column('free', sa.BigInteger(), nullable=False),
    sa.Column('used', sa.BigInteger(), nullable=False),
    sa.Column('reset', sa.Boolean(), nullable=False),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_disk_usage_stat'))
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_tb_mail_outbox_alert_type'), table_name='tb_mail_outbox')
    op.drop_index(op.f('ix_tb_mail_outbox_display_name'), table_name='tb_mail_outbox')
    op.drop_index(op.f('ix_tb_mail_outbox_alert_guid'), table_name='tb_mail_outbox')
    op.drop_column(u'tb_mail_outbox', 'alert_type')
    op.drop_column(u'tb_mail_outbox', 'display_name')
    op.drop_column(u'tb_mail_outbox', 'alert_guid')
    op.drop_table('tb_journal_checkpoint')
    op.drop_column('tb_mail_alert_rule', 'check_frequency')
    op.drop_table('tb_mail_alert_custom_rule')
    op.execute('DROP SEQUENCE tb_mail_alert_custom_rule_alert_id_seq')
    op.drop_table('tb_ignore_rule')
    op.drop_column('tb_mail_outbox', 'extra_setting')
    op.drop_column('tb_mail_outbox', 'attachments')
    op.drop_table('tb_user_usergroup')
    op.drop_table('tb_usergroup_role')
    op.drop_table('tb_acl_owner')
    op.drop_table('tb_widget_template')
    op.drop_table('tb_widget_instance')
    op.drop_table('tb_widget_category')
    op.drop_table('tb_log_view_filter_instance')
    op.drop_table('tb_log_view_filter')
    op.drop_table('tb_rpc_task')
    op.drop_table('tb_local_cache')
    op.drop_table('tb_syslog_forward_task')
    op.drop_table('tb_syslog_forward_server')
    op.drop_table('tb_disk_usage_stat')
    ### end Alembic commands ###
